#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=..\update.ico
#AutoIt3Wrapper_Outfile=tv10_host.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=TeamViewer 10 Host unattented installscript
#AutoIt3Wrapper_Res_Description=This script automates the TeamViewer 10 Host setup
#AutoIt3Wrapper_Res_Fileversion=1.4.0.0
#AutoIt3Wrapper_Res_LegalCopyright= 2015 <https://blog.mcdope.org/>
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

$verTag = "10" ; Tested with installer version 10.0.38475.0
$strTrayTitle = "TeamViewer " & $verTag & " Host Auto-Install"

$wTitle = "TeamViewer " & $verTag & " Host Installation"
$wTitle2 = "Unbeaufsichtigter Zugriff"
$wTitle3 = "Unbeaufsichtigter Zugriff - Schritt 1 von 2"
$wTitle4 = "Unbeaufsichtigter Zugriff - Schritt 2 von 2"
$strUser = IniRead(@ScriptDir & "\tv" & $verTag & "_host.conf", "Setup", "AccountUsername", "")
$strPass = IniRead(@ScriptDir & "\tv" & $verTag & "_host.conf", "Setup", "AccountPassword", "")
$strPassword = IniRead(@ScriptDir & "\tv" & $verTag & "_host.conf", "Setup", "ConnectPassword", "")
$iDelay = Int(IniRead(@ScriptDir & "\tv" & $verTag & "_host.conf", "Advanced", "SleepDelay", "0"))
Opt("SendKeyDelay", Int(IniRead(@ScriptDir & "\tv" & $verTag & "_host.conf", "Setup", "SendKeyDelay", "250")) )

$iErr = 0;
If $strUser == "" Then
	MsgBox(0, "Fehler!", "Der Teamviewer-Account ('AccountUsername') konnte nicht in tv" & $verTag & "_host.conf gefunden werden!");
	$iErr = 1;
EndIf
If $strPass == "" Then
	MsgBox(0, "Fehler!", "Das Teamviewer-Account Passwort ('AccountPassword') konnte nicht in tv" & $verTag & "_host.conf  gefunden werden!");
	$iErr = 1;
EndIf
If $strPassword == "" Then
	MsgBox(0, "Fehler!", "Das Verbindungs-Passwort ('ConnectPassword') konnte nicht in tv" & $verTag & "_host.conf gefunden werden!");
	$iErr = 1;
EndIf
If $iErr == 1 Then
	Exit
EndIf

; Install
TrayTip($strTrayTitle, "Warte auf Setup...", 0, 1)
WinWait($wTitle)
Sleep($iDelay)
TrayTip($strTrayTitle, "Konfiguriere Installation...", 0, 1)
WinActivate($wTitle)
WinWaitActive($wTitle)
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:4]") ; Erweiterte Einstellungen check
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle, "Einsatzbereich")
Sleep($iDelay)
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:4]") ; Privat radio
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle, "Lizenzabkommen")
Sleep($iDelay)
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:4]") ; Akzeptiere... check
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:5]") ; Privat check
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle, "TeamViewer Komponenten verwenden")
Sleep($iDelay)
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle, "Zielverzeichnis")
Sleep($iDelay)
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWaitClose($wTitle)

; Install done - adding to list
TrayTip($strTrayTitle, "Installation abgeschlossen, fge Computer zur Support-Liste hinzu...", 0, 1)
WinWait($wTitle2, "Unbeaufsichtigten Zugriff einrichten")
WinActivate($wTitle2)
Sleep($iDelay)
WinWaitActive($wTitle2)
ControlClick($wTitle2, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle3, "Kennwort")
WinActivate($wTitle3)
Sleep($iDelay)
WinWaitActive($wTitle3)
ControlSend($wTitle3, "", "[CLASS:Edit; INSTANCE:2]", $strPassword, 1) ; Passwort 1
Sleep($iDelay)
ControlSend($wTitle3, "", "[CLASS:Edit; INSTANCE:3]", $strPassword, 1) ; Passwort confirm
Sleep($iDelay)
ControlClick($wTitle3, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle4, "Ich habe bereits ein TeamViewer Konto")
WinActivate($wTitle4)
Sleep($iDelay)
WinWaitActive($wTitle4)
ControlClick($wTitle4, "", "[CLASS:Button; INSTANCE:2]") ; Ich habe bereits ein TeamViewer Konto
ControlSend($wTitle4, "", "[CLASS:Edit; INSTANCE:2]", $strUser, 1) ; User
Sleep($iDelay)
ControlSend($wTitle4, "", "[CLASS:Edit; INSTANCE:3]", $strPass, 1) ; Pass
Sleep($iDelay)
ControlClick($wTitle4, "", "[CLASS:Button; INSTANCE:6]") ; Weiter
WinWait($wTitle2, "Abschluss des Assistenten")
WinActivate($wTitle2)
Sleep($iDelay)
WinWaitActive($wTitle2)
ControlClick($wTitle2, "", "[CLASS:Button; INSTANCE:7]") ; Fertigstellen
WinWaitClose($wTitle2)
TrayTip($strTrayTitle, "", 0, 1)

; Close info dialog
WinWait("TeamViewer", "www.teamviewer.com")
WinActivate("TeamViewer")
Sleep($iDelay)
WinWaitActive("TeamViewer")
ControlClick("TeamViewer", "", "[CLASS:Button; INSTANCE:1]") ; OK

; Import configuration (if exists)
Local $iFileExists = FileExists(@ScriptDir & "\tv" & $verTag & "_host.reg")
If $iFileExists Then
	TrayTip($strTrayTitle, "Alles erledigt, setze noch ein paar Einstellungen...", 0, 1)
	RunWait(@ComSpec & " /c net stop TeamViewer", @ScriptDir)
	RunWait(@ComSpec & " /c ""regedit.exe /s tv" & $verTag & "_host.reg""", @ScriptDir)
	RunWait(@ComSpec & " /c net start TeamViewer", @ScriptDir)
EndIf

; Close info dialog
WinWait("Information", "TeamViewer Host ist nun auf diesem Computer installiert und startet automatisch mit Windows. Nutzen Sie Ihre ID und das von Ihnen bei der Installation eingegebene Kennwort, um aus der Ferne auf diesen Computer zuzugreifen.")
WinActivate("Information", "TeamViewer Host ist nun auf diesem Computer installiert und startet automatisch mit Windows. Nutzen Sie Ihre ID und das von Ihnen bei der Installation eingegebene Kennwort, um aus der Ferne auf diesen Computer zuzugreifen.")
Sleep($iDelay)
WinWaitActive("Information")
ControlClick("Information", "", "[CLASS:Button; INSTANCE:1]") ; OK

TrayTip($strTrayTitle, "Alles fertig - beende mich.", 15, 1)
Exit