#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=..\update.ico
#AutoIt3Wrapper_Outfile=tv9_full.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=TeamViewer 9 unattented installscript
#AutoIt3Wrapper_Res_Description=This script automates the TeamViewer 9 setup
#AutoIt3Wrapper_Res_Fileversion=1.1.0.0
#AutoIt3Wrapper_Res_LegalCopyright= 2014 <https://blog.mcdope.org/>
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

$verTag = "9"
$strTrayTitle = "TeamViewer " & $verTag & " Auto-Install"

$wTitle = "TeamViewer " & $verTag & " Installation"
$wTitle2 = "Unbeaufsichtigter Zugriff"
$wTitle3 = "Unbeaufsichtigter Zugriff - Schritt 1 von 2"
$wTitle4 = "Unbeaufsichtigter Zugriff - Schritt 2 von 2"
$strUser = IniRead(@ScriptDir & "\tv9_full.conf", "Setup", "AccountUsername", "Du hast vergessen deinen Benutzernamen einzugeben!")
$strPass = IniRead(@ScriptDir & "\tv9_full.conf", "Setup", "AccountPassword", "")
$strPassword = IniRead(@ScriptDir & "\tv9_full.conf", "Setup", "ConnectPassword", "")
Opt("SendKeyDelay", Int(IniRead(@ScriptDir & "\tv9_full.conf", "Setup", "SendKeyDelay", "250")) )

; Install
TrayTip($strTrayTitle, "Warte auf Setup...", 0, 1)
WinWait($wTitle, "Installieren, um spter aus der Ferne auf diesen Computer zuzugreifen")
TrayTip($strTrayTitle, "Konfiguriere Installation...", 0, 1)
WinActivate($wTitle)
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:5]") ; Installieren, um spter aus der Ferne auf diesen Computer zuzugreifen check
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:8]") ; privat / nicht-kommerziell check
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:10]") ; Erweiterte Einstellungen check
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Stimme zu - weiter
WinWait($wTitle, "Erweiterte Einstellungen")
ControlClick($wTitle, "", "[CLASS:Button; INSTANCE:2]") ; Fertig stellen
WinWaitClose($wTitle)

; Install done - adding to list
TrayTip($strTrayTitle, "Installation abgeschlossen, fge Computer zur Support-Liste hinzu...", 0, 1)
WinWait($wTitle2, "Unbeaufsichtigten Zugriff einrichten")
WinActivate($wTitle2)
ControlClick($wTitle2, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle3, "Kennwort")
WinActivate($wTitle3)
ControlSend($wTitle3, "", "[CLASS:Edit; INSTANCE:2]", $strPassword) ; Passwort 1
ControlSend($wTitle3, "", "[CLASS:Edit; INSTANCE:3]", $strPassword) ; Passwort confirm
ControlClick($wTitle3, "", "[CLASS:Button; INSTANCE:2]") ; Weiter
WinWait($wTitle4, "Ich habe bereits ein TeamViewer Konto")
WinActivate($wTitle4)
ControlClick($wTitle4, "", "[CLASS:Button; INSTANCE:2]") ; Ich habe bereits ein TeamViewer Konto
ControlSend($wTitle4, "", "[CLASS:Edit; INSTANCE:2]", $strUser) ; User
ControlSend($wTitle4, "", "[CLASS:Edit; INSTANCE:3]", $strPass) ; Pass
ControlClick($wTitle4, "", "[CLASS:Button; INSTANCE:6]") ; Weiter
WinWait($wTitle2, "Abschluss des Assistenten")
WinActivate($wTitle2)
ControlClick($wTitle2, "", "[CLASS:Button; INSTANCE:7]") ; Fertigstellen
WinWaitClose($wTitle2)
TrayTip($strTrayTitle, "", 0, 1)

; Close initial launch
WinWait("TeamViewer", "Bitte geben Sie die ID Ihres Partners ein, um dessen Computer fernzusteuern.")
WinActivate("TeamViewer", "Bitte geben Sie die ID Ihres Partners ein, um dessen Computer fernzusteuern.")
WinClose("TeamViewer", "Bitte geben Sie die ID Ihres Partners ein, um dessen Computer fernzusteuern.")

TrayTip($strTrayTitle, "Alles erledigt, setze noch ein paar Einstellungen...", 0, 1)

; Import configuration
RunWait(@ComSpec & " /c net stop TeamViewer9", @ScriptDir)
RunWait(@ComSpec & " /c ""regedit.exe /s tv9_full.reg""", @ScriptDir)
RunWait(@ComSpec & " /c net start TeamViewer9", @ScriptDir)

TrayTip($strTrayTitle, "Alles fertig - beende mich.", 15, 1)
Exit
