#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=clock.ico
#AutoIt3Wrapper_Outfile=TectumTimer.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=Tectum Timer, (c) & (r) Tobias Bumer <TobiasBaeumer@gmail.com>
#AutoIt3Wrapper_Res_Description=Tectum Timer - Geschrieben fr das Team Eisbren (T6773)
#AutoIt3Wrapper_Res_Fileversion=1.1.3.0
#AutoIt3Wrapper_Res_LegalCopyright=(c) & (r) Tobias Bumer <TobiasBaeumer@gmail.com>
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#AutoIt3Wrapper_Run_Before=del %out%
#AutoIt3Wrapper_Run_After=winrar a -afzip -m5 -n@%scriptdir%\__archive.lst -s -u -z%scriptdir%\changelog.txt "%scriptdir%\TectumTimer (Version %fileversion%).zip"
#AutoIt3Wrapper_Run_After=copy "%scriptdir%\TectumTimer (Version %fileversion%).zip" C:\Users\Dev\Dropbox\Public\
#AutoIt3Wrapper_Run_After=del "%scriptdir%\TectumTimer (Version %fileversion%).zip"
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <Constants.au3>
#include <ComboConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <SendMessage.au3>
#include <Date.au3>
#include "_WinSnap.au3"
#include <ScreenCapture.au3>
#include <Array.au3>

Opt("WinTitleMatchMode", 2)

; --> Setup timer globals
Global $Started = False, $Timer = 0, $tmpTimer = 0, $LastTimer = 0
Global $iHours, $iMins, $iSecs, $iHsecs

; --> Read INI
Global $windowToExist = "Editor", $green_max_secs = 0, $yellow_max_secs = 0, $automode = 1, $hotkey = 0, $debug_mode = 0, $_shotCount = 0, $font_name = "Tahoma", $font_size = 36, $font_weight = 800, $traytip = 1, $coord_x = 0, $coord_y = 0, $stats_enabled = 0, $totalCalls = 0, $totalCHT = 0
Global $iniFile = @ScriptDir & "\" & "TectumTimer.ini"
loadConfig()

Global $arrCHTs[1]
$arrCHTs[0] = 0

; --> Tray Icon Setup
Opt("TrayMenuMode", 1)
TraySetToolTip("Tectum Timer")
TraySetIcon("clock.ico")
TraySetClick(0)

; --> GUI Creation
#Region ### START Koda GUI section ### Form=
$MainUI = GUICreate("Tectum Timer", 153, 77, $coord_x, $coord_y, BitOR($WS_POPUP,$DS_SETFOREGROUND), BitOR($WS_EX_TOPMOST,$WS_EX_COMPOSITED, $WS_EX_TOOLWINDOW))
$lbl_timer = GUICtrlCreateLabel("00:00", 0, 0, 153, 62, BitOR($SS_CENTER,$SS_CENTERIMAGE))
GUICtrlSetFont(-1, Int($font_size), Int($font_weight), 0, String($font_name))
$lblCallsTXT = GUICtrlCreateLabel("Calls:", 1, 62, 29, 17)
$lblCallsData = GUICtrlCreateLabel("0", 32, 62, 22, 17)
$lblCHTTXT = GUICtrlCreateLabel("CHT:", 98, 62, 29, 17)
$lblCHTData = GUICtrlCreateLabel("0", 128, 62, 28, 17)
GUISetState(@SW_SHOW)
#EndRegion ### END Koda GUI section ###
HotKeySet($hotkey, "StartStoppHK")
_WinSnap_Set($MainUI)
WinSetTrans("Tectum Timer", 0, IniRead($iniFile, "timer", "alphatrans", 255))
Reset()

; --> Main loop
While 1
	If $automode = 1 And WinExists($windowToExist) = 0 And $Started Then
		StartStopp()
		DebugLog("Kontrolle -> Automatik -> STOP -> Timer gestoppt")
	ElseIf $automode = 1 And WinExists($windowToExist) = 1 And Not $Started Then
		StartStopp()
		DebugLog("Kontrolle -> Automatik -> START -> Timer gestartet")
	EndIf

	$nMsg = GUIGetMsg()
	$tMsg = TrayGetMsg()
	UpdateUI()

	Switch $nMsg
		Case $lbl_timer
			doConfigDialog()
		Case $GUI_EVENT_PRIMARYDOWN
            _SendMessage($MainUI, $WM_SYSCOMMAND, 0xF012, 0)
		Case $GUI_EVENT_CLOSE
			;Exit
	EndSwitch

	Switch $tMsg
		Case $TRAY_EVENT_PRIMARYDOUBLE
			StartStopp()
			DebugLog("Kontrolle -> Manuell -> TrayIcon -> Toggle -> Timer umgeschaltet (Bisheriger Status: " & $Started & ")")
		Case $TRAY_EVENT_SECONDARYDOUBLE
			MsgBox(0, "Konfiguration", "Nach dem Speichern der Konfigurationsdatei bitte den Timer neustarten!")
			ShellExecute("notepad", $iniFile)
	EndSwitch
WEnd


Func UpdateUI()
	; --> Updates the interface
	WinSetOnTop("Tectum Timer", "", 1)
	SetWindowPos($MainUI, $HWND_TOPMOST + $HWND_TOP, 0, 0, 0, 0, BitOR($SWP_NOMOVE,$SWP_NOSIZE))

	If $Started Then
		$tmpTimer = TimerDiff($Timer)
		$LastTimer = $tmpTimer
		Convert() ;Convert ticks to time and split it into MM:SS

		If ($tmpTimer/1000) < $green_max_secs Then
			$_Color = 0x00FF00;
		ElseIf ($tmpTimer/1000) > $green_max_secs And ($tmpTimer/1000) < $yellow_max_secs Then
			$_Color = 0xFFFF00;
		ElseIf ($tmpTimer/1000) > $yellow_max_secs Then
			$_Color = 0xFF0000;
		EndIf

		$_curLabel = GUICtrlRead($lbl_timer)
		$_newLabel = $iMins & ":" &$iSecs
		If $_curLabel <> $_newLabel Then
			DebugLog("Timer -> Daten -> Anzeige -> """ & $_newLabel & """ (Farbe: " & Hex($_Color) & ")")
			GUICtrlSetData($lbl_timer, $_newLabel) ;Update GUI
			GUICtrlSetColor($lbl_timer, $_Color)
		EndIf
	EndIf
EndFunc

Func StartStoppHK()
	; --> Wrapper function for hotkey control
	DebugLog("Kontrolle -> Manuell -> Hotkey (""" & $hotkey & """) -> Toggle -> Timer umgeschaltet (Bisheriger Status: " & $Started & ")")
	StartStopp()
EndFunc

Func StartStopp()
	; --> Interrupt function for start/stop
    If $Started Then ;Stop button pressed
		If $traytip = 1 Then
			TrayTip("Tectum Timer", "Timer gestoppt", 3 , 1)
		EndIf
		$tmpTimer = TimerDiff($Timer)
		$LastTimer = $tmpTimer
        $Started = False
        Convert() ;Convert ticks to time and split it into MM:SS
        GUICtrlSetData($lbl_timer, $iMins & ":" &$iSecs) ;Update GUI

		If $stats_enabled == 1 Then
			_ArrayAdd($arrCHTs, ($tmpTimer/1000))
			$totalCalls = $totalCalls + 1
			Local $tmpCHT
			For $i = 0 to UBound($arrCHTs) -1
				$tmpCHT = $tmpCHT + $arrCHTs[$i]
			Next
			$totalCHT = $tmpCHT / $totalCalls
			$tmpCHT = 0
			If $totalCHT < $green_max_secs Then
				$_ColorCHT = 0x00FF00;
			ElseIf $totalCHT > $green_max_secs And $totalCHT < $yellow_max_secs Then
				$_ColorCHT = 0xFFFF00;
			ElseIf $totalCHT > $yellow_max_secs Then
				$_ColorCHT = 0xFF0000;
			EndIf
			GUICtrlSetData($lblCHTData, Round($totalCHT))
			GUICtrlSetData($lblCallsData, $totalCalls)
			GUICtrlSetColor($lblCHTData, $_ColorCHT)
		EndIf
    Else
		If $traytip = 1 Then
			TrayTip("Tectum Timer", "Timer gestartet", 3 , 1)
		EndIf
        $Started = True
        $Timer = TimerInit()
    EndIf
	$winPos = WinGetPos("Tectum Timer");
	IniWrite($iniFile, "window", "coord_x", $winPos[0]);
	IniWrite($iniFile, "window", "coord_y", $winPos[1]);
EndFunc    ;==>StartStopp

Func Reset()
	; --> Resets GUI
    GUICtrlSetData($lbl_timer, "00:00")
    $LastTimer = 0
    $Timer = TimerInit()
EndFunc    ;==>Reset

Func Convert()
	; --> Convert ticks to time and split it into HH:MM:SS.hh
    _TicksToTime($tmpTimer, $iHours, $iMins, $iSecs)
    $iHsecs = StringRight($tmpTimer, 3)
    $iHsecs = Round($iHsecs / 10)
    If $iHours < 10 Then $iHours = "0" & $iHours
    If $iMins < 10 Then $iMins = "0" & $iMins
    If $iSecs < 10 Then $iSecs = "0" & $iSecs
    If $iHsecs < 10 Then $iHsecs = "0" & $iHsecs
EndFunc    ;==>Convert

Func SetWindowPos($hwnd, $InsertHwnd, $X, $Y, $cX, $cY, $uFlags)
	; --> WinAPI Wrapper for SetWindowPos()
    $ret = DllCall("user32.dll", "long", "SetWindowPos", "hwnd", $hwnd, "hwnd", $InsertHwnd, "int", $X, "int", $Y, "int", $cX, "int", $cY, "long", $uFlags)
    Return $ret[0]
EndFunc

Func DebugLog($strMessage)
	; --> Logs the given message to debuglog.txt and take a shot of the interface
	If $debug_mode == 1 Then
		$hFile = FileOpen(@ScriptDir & "\debuglog.txt", 1)
		$_tag = "[" & @HOUR & ":" & @MIN & ":" & @SEC & "." & @MSEC & "] "
		FileWriteLine($hFile,  $_tag & $strMessage)
		_ScreenCapture_SetJPGQuality(20)
		_ScreenCapture_CaptureWnd(@ScriptDir & "\debugshot-" & $_shotCount & ".jpg", $MainUI)
		$_shotCount = $_shotCount + 1
		FileClose($hFile)
	EndIf
EndFunc

Func doConfigDialog()
	#Region ### START Koda GUI section ### Form=c:\users\dev\dropbox\tectumtimer\configdialog.kxf
	$configDialog = GUICreate("Konfiguration", 264, 455, 192, 124, -1, -1, $MainUI)
	$Group1 = GUICtrlCreateGroup(" Zielwerte ", 3, 0, 257, 105)
	$Label1 = GUICtrlCreateLabel("Maximum CHT fr grne Anzeige", 8, 15, 159, 17)
	$in_max_green_secs = GUICtrlCreateInput("360", 8, 32, 249, 21)
	$Label2 = GUICtrlCreateLabel("Maximum CHT fr gelbe Anzeige", 8, 54, 158, 17)
	$in_max_yellow_secs = GUICtrlCreateInput("400", 8, 71, 249, 21)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	$Group2 = GUICtrlCreateGroup(" Steuerung ", 3, 120, 257, 137)
	$Label3 = GUICtrlCreateLabel("Modus", 8, 140, 36, 17)
	$in_trigger_auto = GUICtrlCreateRadio("Automatisch", 48, 134, 81, 25)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$in_trigger_manual = GUICtrlCreateRadio("Manuell", 136, 134, 65, 25)
	$Label4 = GUICtrlCreateLabel("Tastenkombination fr den manuellen Modus", 8, 160, 216, 17)
	$in_manual_hotkey = GUICtrlCreateInput("^+{SPACE}", 8, 178, 249, 21)
	GUICtrlSetState(-1, $GUI_DISABLE)
	$Label5 = GUICtrlCreateLabel("Fenstertitel der die Automatik auslst", 8, 209, 176, 17)
	$in_trigger_window = GUICtrlCreateInput("Anrufbearbeitung", 8, 227, 249, 21)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	$Group3 = GUICtrlCreateGroup(" Optik && Verhalten ", 3, 272, 257, 145)
	$in_traytip = GUICtrlCreateCheckbox("Traytip (Sprechblase an der Uhr)", 8, 288, 241, 25)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$Label6 = GUICtrlCreateLabel("Transparenz des Timer (255 = Keine Transparenz)", 8, 317, 240, 17)
	$Label7 = GUICtrlCreateLabel("Schriftart, -gre und -dicke", 8, 368, 135, 17)
	$in_font_name = GUICtrlCreateCombo("", 8, 385, 145, 25, BitOR($CBS_DROPDOWN,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Arial|Tahoma|Verdana|Comic Sans MS", "Tahoma")
	$in_font_size = GUICtrlCreateCombo("", 160, 385, 49, 25, BitOR($CBS_DROPDOWN,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "20|22|24|26|28|30|32|34|36|38|40|42|44|46", "36")
	$in_font_weight = GUICtrlCreateCombo("", 216, 385, 41, 25, BitOR($CBS_DROPDOWN,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "200|400|600|800|1000", "800")
	$in_alphatrans = GUICtrlCreateInput("200", 8, 333, 249, 21)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	$btn_save = GUICtrlCreateButton("Speichern && bernehmen", 3, 424, 257, 25)
	GUISetState(@SW_SHOW)
	#EndRegion ### END Koda GUI section ###
EndFunc

Func loadConfig()
	$windowToExist = IniRead($iniFile, "timer", "trigger_window", "Notepad")
	$automode = IniRead($iniFile, "timer", "trigger_auto", 1)
	$green_max_secs = IniRead($iniFile, "timer", "green_max_secs", 360)
	$yellow_max_secs = IniRead($iniFile, "timer", "yellow_max_secs", 400)
	$hotkey = IniRead($iniFile, "timer", "manual_hotkey", "^+{SPACE}")
	$debug_mode = IniRead($iniFile, "timer", "debug_mode", 0)
	$font_name = IniRead($iniFile, "timer", "font_name", "Tahoma")
	$font_size = IniRead($iniFile, "timer", "font_size", 36)
	$font_weight = IniRead($iniFile, "timer", "font_weight", 800)
	$stats_enabled = IniRead($iniFile, "timer", "stats_enabled", 0)
	$traytip = IniRead($iniFile, "timer", "traytip", 1)
	$coord_x = IniRead($iniFile, "window", "coord_x", 0)
	$coord_y = IniRead($iniFile, "window", "coord_y", 0)
EndFunc

Func saveConfig()

EndFunc
